rm(list=ls())
library(lattice)
library(sp)
#--------------------------------------------------------------------------
#   Einstellung von Graphikparametern
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
trellis.par.set(theme = col.whitebg())
axis.line <- trellis.par.get("axis.line");axis.line$col <- "black";axis.line$lwd <- 4;
trellis.par.set("axis.line", axis.line)
par.ylab.text <- trellis.par.get("par.ylab.text");par.ylab.text$cex <- 1.4;
trellis.par.set("par.ylab.text", par.ylab.text)
par.xlab.text <- trellis.par.get("par.xlab.text");par.xlab.text$cex <- 1.4;
trellis.par.set("par.xlab.text", par.xlab.text)
fontsize <- trellis.par.get("fontsize");fontsize$text =14;
trellis.par.set("fontsize", fontsize)
axis.text <- trellis.par.get("axis.text");axis.text$cex =1.4;
trellis.par.set("axis.text", axis.text)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatisitk\\bungen_GS\\Datenstze")
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
dat2 <- dat
dat1 <- dat
dat2[1:5,]
pause()
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat2[,1]
Y <- dat2[,2]
plot(X,Y,asp=1,main="Lage der Messpunkte",pch=13,cex=1.5,col="blue",lwd=2)
#pause()
#--------------------------------------------------------------------------
#   Elementarstatistik
#--------------------------------------------------------------------------
summary(dat2)
#par(ask=T) # damit Graphiken nicht durchrauschen
plot(dat2[,c(3:7)])
par(mfrow=c(1,5))
boxplot(dat2[,3],lwd = 2,col = "blue",notch = T, main = "Precipitation")
boxplot(dat2[,4],lwd = 2,col = "red",notch = T, main = "Electr. Conduct.")
boxplot(dat2[,5],lwd = 2,col = "green",notch = T, main = "pH")
boxplot(dat2[,6],lwd = 2,col = "grey",notch = T, main = "Nitrate Conc.")
boxplot(dat2[,7],lwd = 2,col = "yellow",notch = T, main = "Nitrate Flux")
#--------------------------------------------------------------------------
#   Rumliche Muster
#--------------------------------------------------------------------------
# Farbcodiert
coordinates(dat2) <- c("X","Y")
spplot(dat2, "P", cex=1.5, main = "Niederschlag", key.space="bottom")
spplot(dat2, "EC", cex=1.5, main = "Leitfhigkeit", key.space="bottom")
spplot(dat2, "pH", cex=1.5, main = "pH", key.space="bottom")
spplot(dat2, "NitCo", cex=1.5, main = "Nitratkonzentration", key.space="bottom")
spplot(dat2, "NitFlx", cex=1.5, main = "Nitrateintrag", key.space="bottom")
#
#
# Grencodiert
cc <- complete.cases(dat)
dat1 <- dat[cc,]
coordinates(dat1) <- c("X","Y")
bubble(dat1, "P", main = "Niederschlag", key.space="bottom",col = "blue")
bubble(dat1, "EC", main = "Leitfhigkeit", key.space="bottom",col = "red")
bubble(dat1, "pH", main = "pH", key.space="bottom",col = "green")
bubble(dat1, "NitCo", main = "Nitratkonzentration", key.space="bottom",col = "grey")
bubble(dat1, "NitFlx", main = "Nitrateintrag", key.space="bottom",col = "yellow")
#
#fix(dat) # ein Dateneditor: in der R-Konsole ausprobieren!
par(mfrow=c(1,1))
#
#   --- Schluss ---
#